# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 10
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR10_strategy.txt
# LLM Suggested Fallback: C

def harmonious_mirage(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Initial Phase: Rounds 1-3
    if current_round <= 3:
        return "C"
    
    # Middle Phase: Rounds 4-7
    elif current_round <= 7:
        early_defects = sum(1 for move in opp_history[:3] if move == "D")
        if early_defects >= 2:
            return opp_history[-1] if opp_history else "C"
        else:
            if random.random() < 0.1:
                return "D"
            else:
                return "C"
    
    # Final Phase: Rounds 8-10
    else:
        total_defects = sum(1 for move in opp_history if move == "D")
        if total_defects / len(opp_history) > 0.3:
            return "D"
        elif "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code:
            return "D"
        else:
            return "C"